/*
 *  Go Go Redball!
 *
 *  Copyright (c) 2005-2006 Nate Heagy. nate@heagy.com
 */

/*
 * VARIABLES
 */
var VERSION = "200";

var COLORWIDTH = 90;
var COLORWIDTHMIN = 35;
var MENUPADBASEX = 83; // menulist padding + colorwidth - colorwidth min / 2, or so. keep in sync w/ css
var MENUPADBASEY = 43; // menulist padding top + color's size over 100 / 2. keep in sync w/ css
var VERSIONURL = "http://heagy.com/widgets/gogoredball.xml";

var PULSE_TIME = 25; // 1/1000 seconds
var GRAVITY = 3.5;
var RESISTANCE = 0.98; // air resitance, approx (obviously)
var BLURMIN = 70; // when velocity is over this then we fake motion blur
var FRICTION = 0.95; // this is actually more of a colision penalty
var CUSHION = 2; // amount, in pixels, that the edge will 'absorb' the ball
var FLOOR = 10; // where the floor is, from the edge
var SHADOWDIST = 300; // distance at which shadow disappears
var ESCAPE = 30; // if the ball goes faster than this it is thrown // was 200 in v1 for escape velocity
var EFFECTDELAY = 300; // in milliseconds
var CHECKVERSIONTIME = 60480000; // a week, in milliseconds

var uncheckedDate;
var entirelyUnchecked = true;
var updateAvail = false; // set to true when a newer version is available
var req; // xml request object
var held = false; // the ball has been grabbed by the mouse
var paused = false;
var hidden = false;
var firstRun = false;
    // these are optimistic defaults
var XMIN = 0;
var YMIN = 0;
var XMAX = 1024;
var YMAX = 720;
var oldy = oldx = 0;
var dragy = dragx = 0;
var oldvels = new Array();
var pulseid = null;
var hidden = false; // to stop both onload and onshow from calling startPhysics
var lastEls = new Array();
var currcolor = 'red'; // default is red
var colors = ['green', 'yellow', 'orange', 'red', 'purple', 'blue', 'white'];
var styles = null;

// global scoping change fix
var reflec, startup, redball, shadow, shadowheight, blur1, blur2, blur3;

/*
 * EVENT HANDLERS
 */
function onload() {
	redball = document.getElementById("redball");

	startup = true;
	
	try {
        /* FIRST RUN LOGIC */
        var error = widget.system('/bin/cat hasRun.receipt', null).errorString;
        if (error != undefined) {
            doFirstRun();
        }
        setupBoundaries();
    } catch(e) {
      alert('start-up failed');
    }

	fixFocus();
    window.document.onmousemove = onMove;
    window.document.onmouseup = onThrow;
    window.onkeypress = onKeyPress;
    
    styles = new StyleSheet(document.styleSheets[0]);
    
    lastEl = document.getElementById('red');
    
    for (var ii=0; ii<colors.length; ii++) {
        var id = colors[ii];
        var el = document.getElementById(id);
        el.fx = new fx.Width(el, {duration: EFFECTDELAY});
        el.onrollover = grow;
        el.onmouseup = switchColors;
        rolloverer.add(el);
        
        var elname = document.getElementById(id+"name");
        elname.fx = new fx.Opacity(elname, {duration: EFFECTDELAY});
    }
    var selector = document.getElementById('menulist');
    selector.onrollout = fadeOut;
    rolloverer.add(selector);
    document.getElementById('redball').oncontextmenu = fadeUp;
    
    var waves = document.getElementById('waves');
    waves.fx = new fx.Combo(waves, {height: true, width: true, opacity: true, duration: 200, onComplete: wavePulse});
    
    var slam = document.getElementById('slam');
    slam.fx = new fx.Combo(slam, {height: true, width: true, opacity: true, duration: 400});
    
    var more = document.getElementById('morewidgets');
    more.onmouseup = visitSite;
    more.onrollover = function(el) { el.style.backgroundPosition = "right top"; };
    more.onrollout = function(el) { el.style.backgroundPosition = "left top"; };
    rolloverer.add(more);

	var colorPref = widget.preferenceForKey('ballcolor');
	if (colorPref != undefined) {
		setBallColor(colorPref);
	}

    shadow = document.getElementById("shadow");
    reflec = document.getElementById("reflection");
    shadowheight = Math.round(shadow.offsetHeight / 2);
    blur1 = document.getElementById("blur1");
    blur2 = document.getElementById("blur2");
    blur3 = document.getElementById("blur3");
    redball.onmousedown = onGrab;
    startPhysics();
    
    startup = false;
}
function visitSite() {
    if (updateAvail) {
        var url = "http://heagy.com/widgets/upgrade/?id=ggr&ver="+VERSION+"&rand=asdf";
        widget.openURL(url);
    } else
        widget.openURL("http://heagy.com/widgets/");
}
function checkVersion() {
    if (startup || firstRun)
        return;
    if (!uncheckedDate)
        uncheckedDate = new Date();
    var rand = Math.floor(Math.random()*3);
    if (rand != 2)
        return; // check 1/3 the time we try (I hate apps that check aggressively)
    var check = false;
    if (entirelyUnchecked)
        check = true;
    else {
        var time = uncheckedDate.getTime();
        var nowDate = new Date();
        if (nowDate.getTime() - time > CHECKVERSIONTIME)
            check = true;
    }
    if (check) {
        alert('Go Go Redball! is checking for a new version... YO');
        entirelyUnchecked = false;
        try {
            // if this fails the ball should continue to bounce
            req = new XMLHttpRequest();
            req.onreadystatechange = processReq;
            req.open("GET", VERSIONURL, true);
            req.send("");
        } catch(ex) {
            // swallow
        }
    }
}
function processReq() {
    if (req.readyState == 4) {
        try {
            var xml = req.responseXML;
            var node = xml.getElementsByTagName('GoGoRedball')[0];
            versionStr = node.getAttribute('version');
            updateAvail = true;
            if (parseInt(versionStr) > VERSION)
                showNewVersion();
            else
                uncheckedDate = new Date();
        } catch(ex) {}
    }
}
function showNewVersion() {
    document.getElementById('morewidgets').style.backgroundImage = 'url("images/upgrade-button.png")';
}

function onhide() {
    // the ball will freeze
    //paused = true; // if the ball should only pause on dashboard hide
    stopPhysics();
    hidden = true;
    rolloverer.pause();
    var menu = document.getElementById("menulist");
    if (menu.style.opacity > 0)
    	setTimeout(fadeOut, EFFECTDELAY+100);
}
function onshow() {
	onload();
    // the ball should drop from where it was frozen
    if (hidden) {
        startPhysics();
        hidden = false;
    }
    checkVersion();
}

function doFirstRun() {
	widget.system('/usr/bin/touch hasRun.receipt', null);
	var fullscreen = document.getElementById('firstRunButton');
	fullscreen.onclick = function(e) {
		document.getElementById('firstRunHolder').fx.custom(1, 0);
		firstRun = false;
	}
	fullscreen.onrollover = function(el) {
		el.style.backgroundPosition = 'right top';
	}
	fullscreen.onrollout = function(el) {
		el.style.backgroundPosition = 'left top';
	}
	rolloverer.add(fullscreen);
	rolloverer.start();
	
	var runholder = document.getElementById('firstRunHolder');
	runholder.fx = new fx.Opacity(runholder, {onComplete: function() {
			if (this.el.style.opacity == 0) {
				setupBoundaries();
				this.el.style.display = 'none';
			}
		}
	});
	runholder.style.display = '';
	runholder.fx.custom(0, 1);
	
	firstRun = true;
}

function grow(el) {
	var id = el.id;
	for (var ii=0; ii < colors.length; ii++) {
		var color = colors[ii];
		var colorname = document.getElementById(color+"name");
		if (id == color) {
			el.fx.custom(el.offsetWidth, COLORWIDTH);
			colorname.fx.custom(colorname.style.opacity, 1);
			continue;
		}
		var cel = document.getElementById(color);
		if (cel.offsetWidth > COLORWIDTHMIN) {
			cel.fx.custom(cel.offsetWidth, COLORWIDTHMIN);
			colorname.fx.custom(colorname.style.opacity, 0);
		}
	}
}
function fadeOut(el) {
    document.getElementById('menulist').fade.custom(1, 0);
    if (!firstRun)
	    rolloverer.pause();
    if (!hidden) {
	    startPhysics();
	}
}
function fadeUp(e) {
	paused = false;
    stopPhysics(); // the ball should stay behind the menu, no matter where it is
    // now calculate where to put the menu
    var menupad = getMenuPad();
    var ball = document.getElementById('redball');
    menupad.x = ball.offsetLeft - menupad.x;
    menupad.y = ball.offsetTop - menupad.y;
    var menu = document.getElementById('menulist');
    menu.style.left = menupad.x+'px';
    menu.style.top = menupad.y+'px';
    rolloverer.start();
    if (!menu.fade)
        menu.fade = new fx.Opacity(menu);
    menu.fade.custom(0, 1);
}

function getMenuPad() {
    var menupadx = MENUPADBASEX;
    var menupady = MENUPADBASEY;
    for (var ii=0; ii < colors.length; ii++) {
        if (colors[ii] == currcolor)
            break
        menupadx += COLORWIDTHMIN + 1; // 1 for border
    }
    return {'x':menupadx, 'y':menupady};
}

function switchColors(e) {
    var el = e.target;
    currcolor = el.id;
    setBallColor(currcolor);
    widget.setPreferenceForKey(currcolor, 'ballcolor');
    var menu = document.getElementById('menulist');
    var ball = document.getElementById('redball');
    var menupad = getMenuPad();
    ball.style.left = (menu.offsetLeft + menupad.x)+'px';
    fadeOut();
}

function setBallColor(color) {
    var rule = styles.Rule('.redball');
    var refrule = styles.Rule('#reflection'); // 10.4.7+
    if (color == 'red') {
        rule.style.backgroundImage = 'url("images/redball.png")';
        refrule.style.backgroundImage = 'url("images/reflection.png")';
    } else {
        rule.style.backgroundImage = 'url("images/redball-'+color+'.png")';
        refrule.style.backgroundImage = 'url("images/reflection-'+color+'.png")';
    }
}

/*
 * SETUP EVENT CAPTURE
 */
    //setup mouse move capture
//window.onload = onload; // now happens automatically? 

//setup widget status capture
if (window.widget)
{
    widget.onshow = onshow;
    widget.onhide = onhide;
}
/*
 * PAUSE
 */
function onKeyPress(e) {
	if (document.getElementById('menulist').style.opacity > 0)
		return;
	var code = e.keyCode;
	if (code == 32) {
		if (!paused) {
			paused = true;
			var waves = document.getElementById('waves');
			var wavesholder = document.getElementById('wavesholder');
			
			drawBall(false, false, 0, 0); // stop blur
			stopPhysics();
			
			wavesholder.style.left = redball.offsetLeft - 150 + "px";
			wavesholder.style.top = redball.offsetTop - 150 + "px";
			waves.fx.customFx(300, 150, 300, 150, 0, 1);
		} else {
			startPhysics();
		}
	}
	document.getElementById('hiddentext').value = ""; // just to keep it clean, in case, somehow, it appears
}
function drawSlam(x, y) {
    var slam = document.getElementById('slam');
    var slamHolder = document.getElementById('slamHolder');
    if (x == XMIN)
        x = XMIN - 50;
    if (x == XMAX)
        x = XMAX + 50;
    if (y == YMAX)
        y = YMAX + 50;
    slamHolder.style.left = x - 50 + 'px';
    slamHolder.style.top = y - 50 + 'px';
    slam.fx.customFx(90, 132, 90, 132, 1, 0);
}
function wavePulse() {
	var waves = document.getElementById('waves');
	
	if (waves.style.opacity < 0.5)
		return;
	if (!paused || hidden) {
		waves.fx.customFx(137, 150, 137, 150, 0.8, 0);
		return;
	}
	
	var numindex = waves.src.indexOf('waves-');
	var framenum = parseInt(waves.src[numindex+6]);
	if (framenum) {
		if (framenum==3) {
			framenum = 2;
			wavedir = 'down';
		} else if (framenum==1) {
			framenum = 2;
			wavedir = 'up'
		} else {
			if (wavedir == 'down')
				framenum--;
			else
				framenum++;
		}
		waves.src = 'images/waves-'+framenum+'.png';	
	}
	setTimeout(wavePulse, 80);
	
	/*
	 // this makes dashboard buggy :(
	var waves = document.getElementById('waves');
	if (waves.style.opacity < 0.5)
		return;
	if (!paused) {
		waves.fx.customFx(137, 150, 137, 150, 0.8, 0);
		return;
	}
	if (waves.offsetHeight > 137)
		waves.fx.customFx(142, 137, 142, 137, 0.8, 1);
	else
		waves.fx.customFx(137, 142, 137, 142, 1, 0.8);
	*/
}
function fixFocus() {
 	document.getElementById('hiddentext').focus(); // to stop the error *bonk* when typing
}

/*
 * PHYSICS
 */
function setupBoundaries() {
	if (typeof(widget.resizeAndMoveTo) == 'function') {
		// this is an undocumented function, it could disappear at anytime
		// however the benefits to GGR! are relatively huge, so it's worth
		// the risk
		var origX = window.screenLeft;
		var origY = window.screenTop;
		var width = window.screen.width;
		var height = window.screen.height;
		widget.resizeAndMoveTo(origX+1, origX, width, height);
		if (origX < window.screenLeft) {
			// make doubly sure it works before relying on it
			if (firstRun)
				height = Math.round(height / 2 - 100);
			widget.resizeAndMoveTo(-100, -100, width+400, height+100);
			if (startup) {
				redball.style.left = redball.offsetLeft + (origX + 100) + "px";
				redball.style.top = redball.offsetTop + (origY + 100) + "px";
			}
		}
	}

    XMIN = window.screenLeft * -1 - CUSHION;
    XMIN = Math.max(XMIN, window.screenLeft);
    XMAX = XMIN + window.screen.width - redball.offsetWidth + CUSHION * 2;
    XMAX = Math.min(XMAX, window.outerWidth - redball.offsetWidth);
    YMIN = window.screenTop * -1 - CUSHION;
    YMAX = YMIN + window.screen.height - redball.offsetHeight - FLOOR;
    YMAX = Math.min(YMAX, window.outerHeight - redball.offsetHeight - FLOOR);
}

function startPhysics() {
	if (!paused) {
	    xvel = 0.0;
    	yvel = 0.0;
    }
    paused = false;
    if (pulseid == null || typeof(pulseid) == 'undefined') {
	    pulseid = setInterval(pulse, PULSE_TIME);
	}
}
function stopPhysics() {
    clearInterval(pulseid);
    if (!paused)
	    oldvels = new Array();
    pulseid = null;
}
function onGrab(e) {
    held = true;
    grabX = e.pageX - redball.offsetLeft;
    grabY = e.pageY - redball.offsetTop;
    dragx = e.pageX - grabX;
    dragy = e.pageY - grabY;
    oldx = dragx;
    oldy = dragy;
    if (paused)
    	startPhysics();
}
function onThrow(slammed) {
	if (held) {
	    held = false;
    	if (oldvels.length > 1) {
    		var time = new Date();
    		var stamp = time.getTime();
    		var ii = 1;
    		xvel = yvel = 0;
    		// average over the last half second
    		while (ii < oldvels.length && stamp - oldvels[ii].stamp < 150) {
    			xvel += oldvels[ii].x;
    			yvel += oldvels[ii].y;
    			ii++;
    		}
    		if (ii > 1) {
	    		xvel = Math.round(xvel / (ii-1));
    			yvel = Math.round(yvel / (ii-1));
    		}
    		if (slammed) {
    		  xvel *= 1.33;
    		  yvel *= 1.33;
    		}
    	}
    }
}
function onMove(e) {
    if (held) {
        dragx = e.pageX - grabX;
        dragy = e.pageY - grabY;

        yvel = dragy - oldy;
        xvel = dragx - oldx;
        var time = new Date();
        var stamp = time.getTime();
        oldvels.unshift({'x':xvel, 'y':yvel, 'stamp':stamp});
        if (oldvels.length > 8)
	        oldvels.pop();
        if (Math.sqrt(xvel*xvel + yvel*yvel) > ESCAPE) {
        	// old escape velocity throw. hopefully no longer needed.
            //held = false;
        }
        oldx = dragx;
        oldy = dragy;
    }
}
function pulse() {
	fixFocus();
	
    if (held) {
    	var slam = Math.sqrt(xvel*xvel + yvel*yvel) > ESCAPE;
    	var offscreen = false;
    	if (dragx > XMAX) {
            dragx = XMAX;
            offscreen = true;
        }
        if (dragx < XMIN) {
            dragx = XMIN; //some velocities will take it off screen both ways
            offscreen = true;
        }
        if (dragy > YMAX) {
        	dragy = YMAX;
        	offscreen = true;
        }
        if (slam && offscreen) {
        	drawSlam(dragx, dragy);
        	onThrow(true);
        }
        drawBall(Math.round(dragx), Math.round(dragy), xvel, yvel);
    } else {
        // Y
        yvel = yvel + GRAVITY;
        newy = redball.offsetTop + yvel;
        if (newy > YMAX) {
            yvel = (yvel * -1 + GRAVITY) * FRICTION; // bounce the other way
            if (Math.abs(yvel) > 50) {
                newy = 2*YMAX - newy;
            } else {
                newy = YMAX;
            }
        } else if (newy < YMIN) {
            yvel = yvel * -1 * FRICTION;
            newy = YMIN + (YMIN - newy);
        }
        // X
        xvel *= RESISTANCE;
        newx = redball.offsetLeft + xvel;
        if (newx > XMAX) {
            xvel *= -1;
            xvel *= FRICTION;
            newx = 2*XMAX - newx;
            
        } else if (newx < XMIN) {
            xvel *= -1;
            xvel *= FRICTION;
            newx = XMIN + (XMIN - newx);
            
        }
        // if after all that they still end up off screen - say a crazy velocity - then get them back
        if (newx > XMAX) {
            newx = XMAX;
        }
        if (newx < XMIN) {
            newx = XMIN; //some velocities will take it off screen both ways
        }
        if (newy == YMAX) {
            xvel *= FRICTION; // gliding along the floor 
        }
        drawBall(Math.round(newx), Math.round(newy), xvel, yvel); //handles motion blur, shadow
    }
    widget.setCloseBoxOffset(redball.offsetLeft+20, redball.offsetTop+20);
}
function drawBall(x, y, xvel, yvel) {
    if (Math.sqrt(xvel*xvel + yvel*yvel) > BLURMIN) {
        blur1.style.display="";
        blur2.style.display="visible";
        blur3.style.display="visible";
        
        blur1.style.left = x - (xvel * 0.6) +"px";
        blur2.style.left = x - (xvel * 0.4) +"px";
        blur3.style.left = x - (xvel * 0.2) +"px";
        
        blur1.style.top = y - (yvel * 0.6) +"px";
        blur2.style.top = y - (yvel * 0.4) +"px";
        blur3.style.top = y - (yvel * 0.2) +"px";
        
        blur1.style.opacity = 0.1;
        blur2.style.opacity = 0.18;
        blur3.style.opacity = 0.26;
        redball.style.opacity = 0.6;
    } else {
        blur1.style.display="none";
        blur2.style.display="none";
        blur3.style.display="none";
        redball.style.opacity = 1.0;
    }
    if (x && y) {
		reflec.style.top = (YMAX*2 - y + reflec.offsetHeight - 4)+"px"; //4 is for pseudo perpective/overlap
	    reflec.style.left = x+"px";
	    shadow.style.top = (YMAX + shadowheight) +"px";
	    shadow.style.left = x+"px";
	    shadow.style.opacity = 1.0 - Math.min(1, (YMAX - y) / SHADOWDIST);
	    redball.style.left = x+"px";
	    redball.style.top = y+"px";
	}
}

function Rolloverer() {
    var els = new Array();
    var counter = 0;
    var hits = new Array();
    var misses = new Array();
    var timer = null;
    
    this.add = function(el) {
        counter++;
        el.rollyid = counter;
        els.push(el);
    }
    this.hit = function(el) {
        var newhit = true;
        for (var ii=0; ii<hits.length; ii++) {
            if (hits[ii].rollyid == el.rollyid)
                newhit = false;
        }
        if (newhit) {
            hits.push(el);
            if (el.onrollover)
                if (typeof(el.onrollover) == 'function')
                    el.onrollover(el);
                else if (typeof(el.onrollover) == 'string')
                    eval(el.onrollover);
        }
    }
    this.miss = function(el) {
        var newmiss = false;
        var ii;
        for (ii=0; ii<hits.length; ii++) {
            if (hits[ii].rollyid == el.rollyid) {
                newmiss = true;
                break;
            }
        }
        if (newmiss) {
            hits.splice(ii, 1);
            if (el.onrollout)
                if (typeof(el.onrollout) == 'function')
                    el.onrollout(el);
                else if (typeof(el.onrollout) == 'string')
                    eval(el.onrollout);
        }
    }
    this.check = function() {
        var x = WidgetPosition.getMouseX();
        var y = window.screen.height - WidgetPosition.getMouseY();
        for (var ii=0; ii < els.length; ii++)  {
            var el = els[ii];
            var coords = this.getCoordsFor(els[ii]);
            if (x > coords.x && x < (coords.x + el.offsetWidth) &&
                y > coords.y && y < (coords.y + el.offsetHeight)) {
                this.hit(el);
            } else {
                this.miss(el);
            }
        }
    }
    this.getCoordsFor = function(el) {
        var x = 0;
        var y = 0;
        while (el.offsetParent) {
            x += el.offsetLeft;
            y += el.offsetTop;
            el = el.offsetParent;
        }
        x += window.screenLeft;
        y += window.screenTop;
        return {'x':x, 'y':y};
    }
    this.start = function() {
    	if (timer == null)
	        timer = setInterval(this.check.bind(this), 200);
    }
    this.pause = function() {
        clearInterval(timer);
        timer = null;
    }
    //this.start();
}
rolloverer = new Rolloverer();

function StyleSheet(sheet) {
	// sheet is stored as a private field, mind
	
	// get a rule based on this simple selector
	this.Rule = function(selector) {
		for (var ii=0; ii < sheet.cssRules.length; ii++) {
			rule = sheet.cssRules[ii];
			if (rule.selectorText == selector) {
				return rule;
			}
		}
		try {
			sheet.insertRule(selector+"{}", sheet.length);
			return sheet.cssRules[sheet.length-1];
		} catch (err) {
			alert("Couldn't find or create style: "+selector);
		}
	}
}